/**
 * User competency workflow.
 *
 * @module     tool_lp/user_competency_workflow
 * @copyright  2015 Frédéric Massart - FMCorz.net
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_lp/user_competency_workflow",["jquery","core/templates","core/ajax","core/notification","core/str","tool_lp/menubar","tool_lp/event_base"],(function($,Templates,Ajax,Notification,Str,Menubar,EventBase){var UserCompetencyWorkflow=function(){EventBase.prototype.constructor.apply(this,[])};return(UserCompetencyWorkflow.prototype=Object.create(EventBase.prototype))._nodeSelector='[data-node="user-competency"]',UserCompetencyWorkflow.prototype._cancelReviewRequest=function(data){var call={methodname:"core_competency_user_competency_cancel_review_request",args:{userid:data.userid,competencyid:data.competencyid}};Ajax.call([call])[0].then(function(){this._trigger("review-request-cancelled",data),this._trigger("status-changed",data)}.bind(this)).catch(function(){this._trigger("error-occured",data)}.bind(this))},UserCompetencyWorkflow.prototype.cancelReviewRequest=function(data){this._cancelReviewRequest(data)},UserCompetencyWorkflow.prototype._cancelReviewRequestHandler=function(e){e.preventDefault();var data=this._findUserCompetencyData($(e.target));this.cancelReviewRequest(data)},UserCompetencyWorkflow.prototype._requestReview=function(data){var call={methodname:"core_competency_user_competency_request_review",args:{userid:data.userid,competencyid:data.competencyid}};Ajax.call([call])[0].then(function(){this._trigger("review-requested",data),this._trigger("status-changed",data)}.bind(this)).catch(function(){this._trigger("error-occured",data)}.bind(this))},UserCompetencyWorkflow.prototype.requestReview=function(data){this._requestReview(data)},UserCompetencyWorkflow.prototype._requestReviewHandler=function(e){e.preventDefault();var data=this._findUserCompetencyData($(e.target));this.requestReview(data)},UserCompetencyWorkflow.prototype._startReview=function(data){var call={methodname:"core_competency_user_competency_start_review",args:{userid:data.userid,competencyid:data.competencyid}};Ajax.call([call])[0].then(function(){this._trigger("review-started",data),this._trigger("status-changed",data)}.bind(this)).catch(function(){this._trigger("error-occured",data)}.bind(this))},UserCompetencyWorkflow.prototype.startReview=function(data){this._startReview(data)},UserCompetencyWorkflow.prototype._startReviewHandler=function(e){e.preventDefault();var data=this._findUserCompetencyData($(e.target));this.startReview(data)},UserCompetencyWorkflow.prototype._stopReview=function(data){var call={methodname:"core_competency_user_competency_stop_review",args:{userid:data.userid,competencyid:data.competencyid}};Ajax.call([call])[0].then(function(){this._trigger("review-stopped",data),this._trigger("status-changed",data)}.bind(this)).catch(function(){this._trigger("error-occured",data)}.bind(this))},UserCompetencyWorkflow.prototype.stopReview=function(data){this._stopReview(data)},UserCompetencyWorkflow.prototype._stopReviewHandler=function(e){e.preventDefault();var data=this._findUserCompetencyData($(e.target));this.stopReview(data)},UserCompetencyWorkflow.prototype.enhanceMenubar=function(selector){Menubar.enhance(selector,{'[data-action="request-review"]':this._requestReviewHandler.bind(this),'[data-action="cancel-review-request"]':this._cancelReviewRequestHandler.bind(this)})},UserCompetencyWorkflow.prototype._findUserCompetencyData=function(node){var data,parent=node.parents(this._nodeSelector);if(1!=parent.length)throw new Error("The evidence node was not located.");if(void 0===(data=parent.data())||void 0===data.userid||void 0===data.competencyid)throw new Error("User competency data could not be found.");return data},UserCompetencyWorkflow.prototype.enhanceMenubar=function(selector){Menubar.enhance(selector,{'[data-action="request-review"]':this._requestReviewHandler.bind(this),'[data-action="cancel-review-request"]':this._cancelReviewRequestHandler.bind(this),'[data-action="start-review"]':this._startReviewHandler.bind(this),'[data-action="stop-review"]':this._stopReviewHandler.bind(this)})},UserCompetencyWorkflow.prototype.registerEvents=function(selector){var wrapper=$(selector);wrapper.find('[data-action="request-review"]').click(this._requestReviewHandler.bind(this)),wrapper.find('[data-action="cancel-review-request"]').click(this._cancelReviewRequestHandler.bind(this)),wrapper.find('[data-action="start-review"]').click(this._startReviewHandler.bind(this)),wrapper.find('[data-action="stop-review"]').click(this._stopReviewHandler.bind(this))},UserCompetencyWorkflow}));

//# sourceMappingURL=user_competency_workflow.min.js.map